/*!
 * @file        bsp_dci.h
 *
 * @brief       Header for bsp_dci.c module
 *
 * @version     V1.0.0
 *
 * @date        2022-05-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#ifndef _BSP_DCI_H
#define _BSP_DCI_H

#include "main.h"

#define DCI_DATA_REG_ADDRESS        ((uint32_t) &DCI->DATA)
#define EMMC_LCD_ADDRESS            LCD_SMC_ADDR_DATA

/** DCI GPIO*/
#define DCI_HSYNC_PIN               GPIO_PIN_4
#define DCI_PIXCLK_PIN              GPIO_PIN_6
#define DCI_VSYNC_PIN               GPIO_PIN_7
#define DCI_D0_PIN                  GPIO_PIN_6
#define DCI_D1_PIN                  GPIO_PIN_7
#define DCI_D2_PIN                  GPIO_PIN_8
#define DCI_D3_PIN                  GPIO_PIN_9
#define DCI_D4_PIN                  GPIO_PIN_4
#define DCI_D5_PIN                  GPIO_PIN_6
#define DCI_D6_PIN                  GPIO_PIN_5
#define DCI_D7_PIN                  GPIO_PIN_6

/** function declaration*/
void DCI_Init(void);
void DCI_DMAInit(uint32_t memoryBaseAddr, uint32_t bufferSize, DMA_MEMORY_DATA_SIZE_T memoryDataSize, DMA_MEMORY_INC_T memoryInc,DMA_MEMORYBURST_T DMA_MemoryBurst);
void DCI_Start(void);
void DCI_Stop(void);
#endif
